/**
 * DATrie Preproecessor
 *
 * Author: liwei <liwei@anbutu.com>
 */

#include <stdio.h>
#include <stdlib.h>
#include <datrie/trie.h>
#include <string.h>

#define MAX_KEY    1024

int main(int argc, char *argv[])
{
    Trie *trie;
    AlphaMap *alpha_map;
    AlphaChar alpha_key[MAX_KEY];

    unsigned char line[MAX_KEY], *p;

    FILE *fp;
    
    if (argc < 3) {
        fprintf(stderr, "Usage: dpp <dict_file> <trie_file>\n");
        exit(1);
    }

    fp = fopen(argv[1], "r");
    if (!fp) {
        fprintf(stderr, "Failed to open dict file: %s\n", argv[1]);
        exit(1);
    }

    alpha_map = alpha_map_new();
    if (!alpha_map) {
        fprintf(stderr, "failed to init alpha map\n");
        exit(1);
    }

    alpha_map_add_range(alpha_map, 0x00, 0xff); /* treat all strings as byte stream */

    trie = trie_new(alpha_map);
    if (!trie) {
        fprintf(stderr, "failed to init trie\n");
        exit(1);
    }

    while (p = fgets(line, MAX_KEY, fp)) {
        /* convert to alpha char string */
        while (*p && *p != '\n' && *p != '\r') {
            alpha_key[p-line] = (AlphaChar)*p;
            p++;
        }

        alpha_key[p-line] = '\0';

        if (!trie_store(trie, alpha_key, strlen(line)-1)) {
            fprintf(stderr, "failed to store: %s\n", line);
        }
    }

    if (trie_save(trie, argv[2])) {
        fprintf(stderr, "failed to save trie to file: %s\n", argv[2]);
        exit(1);
    }

    return 0;
}
